/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ProgressBar
extends Control {
    static final int ProgressBarProc;
    static final TCHAR ProgressBarClass;

    static {
        ProgressBarClass = new TCHAR(0, "msctls_progress32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, ProgressBarClass, lpWndClass);
        ProgressBarProc = lpWndClass.lpfnWndProc;
    }

    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ProgressBarProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += OS.GetSystemMetrics(21) * 10;
            height += OS.GetSystemMetrics(3);
        } else {
            width += OS.GetSystemMetrics(2);
            height += OS.GetSystemMetrics(20) * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle() {
        super.createHandle();
        OS.SendMessage(this.handle, 1032, 0, 100);
        OS.SendMessage(this.handle, 1045, 0, 10);
        OS.SendMessage(this.handle, 1044, 10, 0);
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_HIGHLIGHT);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1031, 0, 0);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1031, 1, 0);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1032, 0, 0);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        if (pixel == -1) {
            pixel = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 8193, 0, pixel);
    }

    public boolean setFocus() {
        this.checkWidget();
        return false;
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        if (pixel == -1) {
            pixel = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 1033, 0, pixel);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = OS.SendMessage(this.handle, 1031, 1, 0);
        if (minimum >= 0 && minimum < value) {
            OS.SendMessage(this.handle, 1030, minimum, value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = OS.SendMessage(this.handle, 1031, 0, 0);
        if (value >= 0 && value < maximum) {
            OS.SendMessage(this.handle, 1030, value, maximum);
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        OS.SendMessage(this.handle, 1026, value, 0);
    }

    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 0x10000) != 0) {
            bits |= 1;
        }
        if ((this.style & 0x200) != 0) {
            bits |= 4;
        }
        return bits;
    }

    TCHAR windowClass() {
        return ProgressBarClass;
    }

    int windowProc() {
        return ProgressBarProc;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return new LRESULT(256);
    }
}

