/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    ImageList imageList;
    boolean ignoreSelect;
    boolean dragStarted;
    boolean ignoreResize;
    boolean mouseDown;
    boolean customDraw;
    static final int TableProc;
    static final TCHAR TableClass;

    static {
        TableClass = new TCHAR(0, "SysListView32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, TableClass, lpWndClass);
        TableProc = lpWndClass.lpfnWndProc;
    }

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TableProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int bits = 0;
        if (wHint != -1) {
            bits |= wHint & 0xFFFF;
        } else {
            int width = 0;
            int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
            int i = 0;
            while (i < count) {
                width += OS.SendMessage(this.handle, 4125, i, 0);
                ++i;
            }
            bits |= width & 0xFFFF;
        }
        if (hHint != -1) {
            bits |= hHint << 16;
        }
        int result = OS.SendMessage(this.handle, 4160, -1, bits);
        int width = result & 0xFFFF;
        int height = result >> 16;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0 && hHint != -1) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    void createHandle() {
        int pszText;
        super.createHandle();
        this.state &= 0xFFFFEFFF;
        if ((this.style & 0x20) != 0) {
            int width;
            int empty = OS.SendMessage(this.handle, 4160, 0, 0);
            int oneItem = OS.SendMessage(this.handle, 4160, 1, 0);
            int height = width = (oneItem >> 16) - (empty >> 16);
            this.setCheckboxImageList(width, height);
        }
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
        LVCOLUMN lvColumn = new LVCOLUMN();
        lvColumn.mask = 4;
        int hHeap = OS.GetProcessHeap();
        lvColumn.pszText = pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
        OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 0, lvColumn);
        OS.HeapFree(hHeap, 0, pszText);
        int bits = 16386;
        if ((this.style & 0x10000) != 0) {
            bits |= 0x20;
        }
        OS.SendMessage(this.handle, 4150, bits, bits);
    }

    void createItem(TableColumn column, int index) {
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, count - index);
        this.columns[index] = column;
        if (index == 0) {
            if (count > 0) {
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 2;
                OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 1, lvColumn);
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lvColumn);
                int width = lvColumn.cx;
                int cchTextMax = 1024;
                int hHeap = OS.GetProcessHeap();
                int byteCount = cchTextMax * TCHAR.sizeof;
                int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 11;
                int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
                int i = 0;
                while (i < itemCount) {
                    lvItem.iItem = i++;
                    lvItem.iSubItem = 0;
                    lvItem.pszText = pszText;
                    lvItem.cchTextMax = cchTextMax;
                    OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
                    lvItem.iSubItem = 1;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                    lvItem.iSubItem = 0;
                    lvItem.cchTextMax = 0;
                    lvItem.pszText = 0;
                    lvItem.iImage = -2;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                }
                lvColumn.mask = 23;
                lvColumn.pszText = pszText;
                lvColumn.cchTextMax = cchTextMax;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 0, lvColumn);
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 1, lvColumn);
                lvColumn.fmt = 2048;
                lvColumn.cx = width;
                lvColumn.iImage = -2;
                lvColumn.cchTextMax = 0;
                lvColumn.pszText = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                lvColumn.mask = 1;
                lvColumn.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                if (pszText != 0) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            }
        } else {
            int fmt = 0;
            if ((column.style & 0x1000000) == 0x1000000) {
                fmt = 2;
            }
            if ((column.style & 0x20000) == 131072) {
                fmt = 1;
            }
            LVCOLUMN lvColumn = new LVCOLUMN();
            lvColumn.mask = 3;
            lvColumn.fmt = fmt;
            OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, index, lvColumn);
        }
    }

    void createItem(TableItem item, int index) {
        item.background = -1;
        item.foreground = -1;
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            TableItem[] newItems = new TableItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.iItem = index;
        lvItem.iImage = -2;
        lvItem.mask = 2;
        if ((this.style & 0x20) != 0) {
            lvItem.mask |= 8;
            lvItem.state = 4096;
            lvItem.stateMask = 61440;
        }
        this.ignoreSelect = true;
        int result = OS.SendMessage(this.handle, OS.LVM_INSERTITEM, 0, lvItem);
        this.ignoreSelect = false;
        if (result == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        int i = 0;
        while (i < indices.length) {
            lvItem.iItem = indices[i];
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
            this.ignoreSelect = false;
            ++i;
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        lvItem.iItem = index;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
        this.ignoreSelect = false;
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        int i = start;
        while (i <= end) {
            lvItem.iItem = i++;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
            this.ignoreSelect = false;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        OS.SendMessage(this.handle, 4139, -1, lvItem);
    }

    void destroyItem(TableColumn column) {
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        int index = 0;
        while (index < count) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        boolean first = false;
        if (index == 0) {
            first = true;
            if (count > 1) {
                index = 1;
                int cchTextMax = 1024;
                int hHeap = OS.GetProcessHeap();
                int byteCount = cchTextMax * TCHAR.sizeof;
                int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 6;
                lvColumn.pszText = pszText;
                lvColumn.cchTextMax = cchTextMax;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lvColumn);
                lvColumn.mask |= 1;
                lvColumn.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 11;
                lvItem.pszText = pszText;
                lvItem.cchTextMax = cchTextMax;
                int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
                int i = 0;
                while (i < itemCount) {
                    lvItem.iItem = i++;
                    lvItem.iSubItem = 1;
                    OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
                    lvItem.iSubItem = 0;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
                }
                if (pszText != 0) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
            } else {
                int hHeap = OS.GetProcessHeap();
                int pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
                LVCOLUMN lvColumn = new LVCOLUMN();
                lvColumn.mask = 4;
                lvColumn.pszText = pszText;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lvColumn);
                if (pszText != 0) {
                    OS.HeapFree(hHeap, 0, pszText);
                }
                OS.SendMessage(this.handle, 4126, 0, -1);
            }
        }
        if (count > 1 && OS.SendMessage(this.handle, 4124, index, 0) == 0) {
            this.error(15);
        }
        if (first) {
            index = 0;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --count - index);
        this.columns[count] = null;
    }

    void destroyItem(TableItem item) {
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        this.ignoreSelect = true;
        int code = OS.SendMessage(this.handle, 4104, index, 0);
        this.ignoreSelect = false;
        if (code == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4099, 1, 0);
                Display display = this.getDisplay();
                display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.customDraw = false;
            this.items = new TableItem[4];
        }
    }

    void fixCheckboxImageList() {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int hImageList = OS.SendMessage(this.handle, 4098, 1, 0);
        if (hImageList == 0) {
            return;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(hImageList, cx, cy);
        int hOldStateList = OS.SendMessage(this.handle, 4098, 2, 0);
        if (hOldStateList == 0) {
            return;
        }
        int[] stateCx = new int[1];
        int[] stateCy = new int[1];
        OS.ImageList_GetIconSize(hOldStateList, stateCx, stateCy);
        if (cx[0] == stateCx[0] && cy[0] == stateCy[0]) {
            return;
        }
        this.setCheckboxImageList(cx[0], cy[0]);
    }

    int getBackgroundPixel() {
        return OS.SendMessage(this.handle, 4096, 0, 0);
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        return count;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            count = 0;
        }
        TableColumn[] result = new TableColumn[count];
        System.arraycopy(this.columns, 0, result, 0, count);
        return result;
    }

    int getFocusIndex() {
        return OS.SendMessage(this.handle, 4108, -1, 1);
    }

    int getForegroundPixel() {
        return OS.SendMessage(this.handle, 4131, 0, 0);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        if (hwndHeader == 0) {
            return 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(hwndHeader, rect);
        return rect.bottom - rect.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 0x4000) == 0;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = point.x;
        pinfo.y = point.y;
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        if (pinfo.iItem != -1) {
            return this.items[pinfo.iItem];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4100, 0, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int empty = OS.SendMessage(this.handle, 4160, 0, 0);
        int oneItem = OS.SendMessage(this.handle, 4160, 1, 0);
        return (oneItem >> 16) - (empty >> 16);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        TableItem[] result = new TableItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        return (bits & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int i = -1;
        int j = 0;
        int count = OS.SendMessage(this.handle, 4146, 0, 0);
        TableItem[] result = new TableItem[count];
        while ((i = OS.SendMessage(this.handle, 4108, i, 2)) != -1) {
            result[j++] = this.items[i];
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4146, 0, 0);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int focusIndex = OS.SendMessage(this.handle, 4108, -1, 1);
        int selectedIndex = OS.SendMessage(this.handle, 4108, -1, 2);
        if (focusIndex == selectedIndex) {
            return selectedIndex;
        }
        int i = -1;
        while ((i = OS.SendMessage(this.handle, 4108, i, 2)) != -1) {
            if (i != focusIndex) continue;
            return i;
        }
        return selectedIndex;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int i = -1;
        int j = 0;
        int count = OS.SendMessage(this.handle, 4146, 0, 0);
        int[] result = new int[count];
        while ((i = OS.SendMessage(this.handle, 4108, i, 2)) != -1) {
            result[j++] = i;
        }
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4135, 0, 0);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle bounds = image.getBounds();
            this.imageList = this.getDisplay().getImageList(new Point(bounds.width, bounds.height));
            int index = this.imageList.indexOf(image);
            if (index == -1) {
                index = this.imageList.add(image);
            }
            int hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4099, 1, hImageList);
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.imageList.add(image);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.stateMask = 2;
        lvItem.iItem = index;
        int result = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
        return result != 0 && (lvItem.state & 2) != 0;
    }

    void releaseWidget() {
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int columnCount = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (columnCount == 1 && this.columns[0] == null) {
            columnCount = 0;
        }
        int i = 0;
        while (i < columnCount) {
            TableColumn column = this.columns[i];
            if (!column.isDisposed()) {
                column.releaseWidget();
            }
            ++i;
        }
        this.columns = null;
        int itemCount = OS.SendMessage(this.handle, 4100, 0, 0);
        OS.SendMessage(this.handle, 11, 0, 0);
        int i2 = itemCount - 1;
        while (i2 >= 0) {
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4104, i2, 0);
            this.ignoreSelect = false;
            TableItem item = this.items[i2];
            if (!item.isDisposed()) {
                item.releaseWidget();
            }
            --i2;
        }
        this.customDraw = false;
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1, 0);
            Display display = this.getDisplay();
            display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        int hOldList = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, 0);
        if (hOldList != 0) {
            OS.ImageList_Destroy(hOldList);
        }
        super.releaseWidget();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int last = -1;
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last || i == 0) {
                this.ignoreSelect = true;
                int code = OS.SendMessage(this.handle, 4104, index, 0);
                this.ignoreSelect = false;
                if (code == 0) {
                    if (index >= 0 && index < count) {
                        this.error(15);
                    } else {
                        this.error(6);
                    }
                }
                this.items[index].releaseWidget();
                System.arraycopy(this.items, index + 1, this.items, index, --count - index);
                this.items[count] = null;
                last = index;
            }
            ++i;
        }
    }

    public void remove(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        this.ignoreSelect = true;
        int code = OS.SendMessage(this.handle, 4104, index, 0);
        this.ignoreSelect = false;
        if (code == 0) {
            if (index >= 0 && index < count) {
                this.error(15);
            } else {
                this.error(6);
            }
        }
        TableItem item = this.items[index];
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        item.releaseWidget();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        int index = start;
        while (index <= end) {
            this.ignoreSelect = true;
            int code = OS.SendMessage(this.handle, 4104, start, 0);
            this.ignoreSelect = false;
            if (code == 0) break;
            this.items[index].releaseWidget();
            ++index;
        }
        System.arraycopy(this.items, index, this.items, start, count - index);
        int i = count - (index - start);
        while (i < count) {
            this.items[i] = null;
            ++i;
        }
        if (index <= end) {
            if (index >= 0 && index < count) {
                this.error(15);
            } else {
                this.error(6);
            }
        }
    }

    public void removeAll() {
        boolean redraw;
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (redraw) {
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        int index = count - 1;
        while (index >= 0) {
            this.ignoreSelect = true;
            int code = OS.SendMessage(this.handle, 4104, index, 0);
            this.ignoreSelect = false;
            if (code == 0) break;
            this.items[index].releaseWidget();
            --index;
        }
        if (redraw) {
            OS.SendMessage(this.handle, 11, 1, 0);
        }
        if (index != -1) {
            this.error(15);
        }
        if (this.imageList != null) {
            int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            int columnCount = OS.SendMessage(hwndHeader, 4608, 0, 0);
            if (columnCount == 1 && this.columns[0] == null) {
                columnCount = 0;
            }
            int i = 0;
            while (i < columnCount) {
                TableColumn column = this.columns[i];
                if (column.getImage() != null) break;
                ++i;
            }
            if (i == columnCount) {
                OS.SendMessage(this.handle, 4099, 1, 0);
                Display display = this.getDisplay();
                display.releaseImageList(this.imageList);
            }
        }
        this.imageList = null;
        this.customDraw = false;
        this.items = new TableItem[4];
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 2;
        lvItem.stateMask = 2;
        int i = indices.length - 1;
        while (i >= 0) {
            lvItem.iItem = indices[i];
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
            this.ignoreSelect = false;
            --i;
        }
    }

    public void select(int index) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 2;
        lvItem.stateMask = 2;
        lvItem.iItem = index;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
        this.ignoreSelect = false;
    }

    public void select(int start, int end) {
        this.checkWidget();
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 2;
        lvItem.stateMask = 2;
        int i = start;
        while (i <= end) {
            lvItem.iItem = i++;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
            this.ignoreSelect = false;
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 2;
        lvItem.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lvItem);
        this.ignoreSelect = false;
    }

    LRESULT sendMouseDownEvent(int type, int button, int msg, int wParam, int lParam) {
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = (short)(lParam & 0xFFFF);
        pinfo.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        this.sendMouseEvent(type, button, msg, wParam, lParam);
        OS.SetFocus(this.handle);
        if (pinfo.iItem == -1) {
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        int oldState = 0;
        if ((this.style & 4) != 0 && pinfo.iItem != -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 2;
            lvItem.iItem = pinfo.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
            oldState = lvItem.state;
        }
        this.dragStarted = false;
        int code = this.callWindowProc(msg, wParam, lParam);
        if ((this.style & 4) != 0 && pinfo.iItem != -1 && (oldState & 2) != 0) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 2;
            lvItem.iItem = pinfo.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
            int newState = lvItem.state;
            if ((newState & 2) != 0) {
                Event event = new Event();
                event.item = this.items[pinfo.iItem];
                this.postEvent(13, event);
            }
        }
        if (this.dragStarted) {
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean fakeMouseUp;
            int flags = 6;
            boolean bl = fakeMouseUp = (pinfo.flags & flags) != 0;
            if (!fakeMouseUp && (this.style & 2) != 0) {
                boolean bl2 = fakeMouseUp = (pinfo.flags & 8) == 0;
            }
            if (fakeMouseUp) {
                this.mouseDown = false;
                this.sendMouseEvent(4, button, msg, wParam, lParam);
            }
        }
        this.dragStarted = false;
        return new LRESULT(code);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        if (pixel == -1) {
            pixel = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 4097, 0, pixel);
        OS.SendMessage(this.handle, 4134, 0, pixel);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageListColor();
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void setCheckboxImageListColor() {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int hOldStateList = OS.SendMessage(this.handle, 4098, 2, 0);
        if (hOldStateList == 0) {
            return;
        }
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(hOldStateList, cx, cy);
        this.setCheckboxImageList(cx[0], cy[0]);
    }

    void setCheckboxImageList(int width, int height) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 4;
        int hStateList = OS.ImageList_Create(width, height, 0, count, count);
        int hDC = OS.GetDC(this.handle);
        int memDC = OS.CreateCompatibleDC(hDC);
        int hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        int hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        int hBrush = OS.CreateSolidBrush(this.getBackgroundPixel());
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        int oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = new TEXTMETRIC();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2 + 1;
        OS.SetRect(rect, left, top, left + itemWidth, top + itemHeight);
        OS.DrawFrameControl(memDC, rect, 4, 16384);
        rect.left += width;
        rect.right += width;
        OS.DrawFrameControl(memDC, rect, 4, 17408);
        rect.left += width;
        rect.right += width;
        OS.DrawFrameControl(memDC, rect, 4, 16640);
        rect.left += width;
        rect.right += width;
        OS.DrawFrameControl(memDC, rect, 4, 17664);
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        OS.ImageList_AddMasked(hStateList, hBitmap, 0);
        OS.DeleteObject(hBitmap);
        int hOldStateList = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, hStateList);
        if (hOldStateList != 0) {
            OS.ImageList_Destroy(hOldStateList);
        }
    }

    void setFocusIndex(int index) {
        LVITEM lvItem = new LVITEM();
        lvItem.mask = 8;
        lvItem.state = 1;
        lvItem.stateMask = 1;
        lvItem.iItem = index;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
        this.ignoreSelect = false;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.setScrollWidth();
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        OS.InvalidateRect(hwndHeader, null, true);
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((bits & 1) == 0) {
            return;
        }
        bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x4000) != 0) {
            return;
        }
        this.setRowHeight();
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        if (pixel == -1) {
            pixel = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 4132, 0, pixel);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setHeaderVisible(boolean show) {
        int bits;
        this.checkWidget();
        int newBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFBFFF;
        if (!show) {
            newBits |= 0x4000;
        }
        int topIndex = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, newBits);
        if (topIndex != 0) {
            this.setTopIndex(topIndex);
        }
        if (show && ((bits = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
            this.setRowHeight();
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        int newBits = 0;
        if (show) {
            newBits = 1;
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 0x4000) == 0) {
                this.setRowHeight();
            }
        }
        OS.SendMessage(this.handle, 4150, 1, newBits);
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0) {
                this.setScrollWidth();
                this.ignoreResize = true;
                OS.SendMessage(this.handle, 11, 1, 0);
                if (!this.ignoreResize) {
                    int count = this.getChildrenCount();
                    if (count > 1 && this.hdwp == 0) {
                        this.hdwp = OS.BeginDeferWindowPos(count);
                    }
                    if (this.layout != null) {
                        this.layout.layout(this, false);
                    }
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return;
                    }
                    int oldHdwp = this.hdwp;
                    this.hdwp = 0;
                    if (oldHdwp != 0) {
                        OS.EndDeferWindowPos(oldHdwp);
                    }
                }
                this.ignoreResize = false;
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
            int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
            if (hwndHeader != 0) {
                OS.SendMessage(hwndHeader, 11, 0, 0);
            }
        }
    }

    void setRowHeight() {
        if ((Widget.COMCTL32_MAJOR << 16 | Widget.COMCTL32_MINOR) >= 327760) {
            return;
        }
        int hOldList = OS.SendMessage(this.handle, 4098, 1, 0);
        if (hOldList != 0) {
            return;
        }
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rect = new RECT();
        OS.GetWindowRect(hwndHeader, rect);
        int height = rect.bottom - rect.top - 1;
        int hImageList = OS.ImageList_Create(1, height, 0, 0, 0);
        OS.SendMessage(this.handle, 4099, 1, hImageList);
        OS.SendMessage(this.handle, 4099, 1, 0);
        OS.ImageList_Destroy(hImageList);
    }

    void setScrollWidth() {
        if (this.drawCount != 0) {
            return;
        }
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (count == 1 && this.columns[0] == null) {
            OS.SendMessage(this.handle, 4126, 0, -1);
        }
    }

    public void setSelection(int[] indices) {
        int focusIndex;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        this.select(indices);
        if (indices.length != 0 && (focusIndex = indices[0]) != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0) {
            return;
        }
        int focusIndex = -1;
        if ((this.style & 4) != 0) {
            length = 1;
        }
        int i = length - 1;
        while (i >= 0) {
            int index = this.indexOf(items[i]);
            if (index != -1) {
                focusIndex = index;
                this.select(focusIndex);
            }
            --i;
        }
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.select(index);
        if (index != -1) {
            this.setFocusIndex(index);
        }
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        int focusIndex;
        this.checkWidget();
        this.deselectAll();
        this.select(start, end);
        int n = focusIndex = (this.style & 4) != 0 ? end : start;
        if (focusIndex != -1) {
            this.setFocusIndex(focusIndex);
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int topIndex = OS.SendMessage(this.handle, 4135, 0, 0);
        if (index == topIndex) {
            return;
        }
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, index, 1);
            if (index != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, index, 1);
            }
            return;
        }
        RECT rect = new RECT();
        rect.left = 0;
        OS.SendMessage(this.handle, 4110, 0, rect);
        int dy = (index - topIndex) * (rect.bottom - rect.top);
        OS.SendMessage(this.handle, 4116, 0, dy);
    }

    public void showItem(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            return;
        }
        int index = this.indexOf(item);
        if (index != -1) {
            OS.SendMessage(this.handle, 4115, index, 0);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            return;
        }
        int index = OS.SendMessage(this.handle, 4108, -1, 2);
        if (index != -1) {
            OS.SendMessage(this.handle, 4115, index, 0);
        }
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40 | 0x2000000;
        if ((this.style & 0x8000) == 0) {
            bits |= 8;
        }
        if ((this.style & 4) != 0) {
            bits |= 4;
        }
        return bits |= 0x4001;
    }

    TCHAR windowClass() {
        return TableClass;
    }

    int windowProc() {
        return TableProc;
    }

    LRESULT WM_GETOBJECT(int wParam, int lParam) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        int index;
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x20) != 0 && wParam == 32 && (index = OS.SendMessage(this.handle, 4108, -1, 1)) != -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.stateMask = 61440;
            lvItem.iItem = index;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
            int state = lvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            lvItem.state = state << 12;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
        }
        return result;
    }

    LRESULT WM_LBUTTONDBLCLK(int wParam, int lParam) {
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = (short)(lParam & 0xFFFF);
        pinfo.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        this.sendMouseEvent(3, 1, 513, wParam, lParam);
        this.sendMouseEvent(8, 1, 515, wParam, lParam);
        if (pinfo.iItem != -1) {
            this.callWindowProc(515, wParam, lParam);
        }
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        this.mouseDown = true;
        LRESULT result = this.sendMouseDownEvent(3, 1, 513, wParam, lParam);
        if ((this.style & 0x20) != 0) {
            LVHITTESTINFO pinfo = new LVHITTESTINFO();
            pinfo.x = (short)(lParam & 0xFFFF);
            pinfo.y = (short)(lParam >> 16);
            int index = OS.SendMessage(this.handle, 4114, 0, pinfo);
            if (index != -1 && pinfo.flags == 8) {
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 8;
                lvItem.stateMask = 61440;
                lvItem.iItem = index;
                OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lvItem);
                int state = lvItem.state >> 12;
                state = (state & 1) != 0 ? ++state : --state;
                lvItem.state = state << 12;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
            }
        }
        return result;
    }

    LRESULT WM_LBUTTONUP(int wParam, int lParam) {
        this.mouseDown = false;
        return super.WM_LBUTTONUP(wParam, lParam);
    }

    LRESULT WM_MOUSEHOVER(int wParam, int lParam) {
        int mask;
        LRESULT result = super.WM_MOUSEHOVER(wParam, lParam);
        int bits = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((bits & (mask = 200)) != 0) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        int hwndHeader = OS.SendMessage(this.handle, 4127, 0, 0);
        if (hdr.hwndFrom == hwndHeader) {
            switch (hdr.code) {
                case -326: 
                case -306: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    TableColumn column = this.columns[phdn.iItem];
                    if (column == null || column.getResizable()) break;
                    return LRESULT.ONE;
                }
                case -321: 
                case -301: {
                    TableColumn column;
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    Event event = new Event();
                    if (phdn.pitem == 0) break;
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    if ((pitem.mask & 1) == 0 || (column = this.columns[phdn.iItem]) == null) break;
                    column.sendEvent(11, event);
                    if (this.isDisposed()) {
                        return LRESULT.ZERO;
                    }
                    int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
                    if (count == 1 && this.columns[0] == null) {
                        count = 0;
                    }
                    TableColumn[] newColumns = new TableColumn[count];
                    System.arraycopy(this.columns, 0, newColumns, 0, count);
                    int i = phdn.iItem + 1;
                    while (i < count) {
                        if (!newColumns[i].isDisposed()) {
                            newColumns[i].sendEvent(10, event);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        return super.WM_NOTIFY(wParam, lParam);
    }

    LRESULT WM_RBUTTONDBLCLK(int wParam, int lParam) {
        LVHITTESTINFO pinfo = new LVHITTESTINFO();
        pinfo.x = (short)(lParam & 0xFFFF);
        pinfo.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4114, 0, pinfo);
        this.sendMouseEvent(3, 1, 516, wParam, lParam);
        this.sendMouseEvent(8, 1, 518, wParam, lParam);
        if (pinfo.iItem != -1) {
            this.callWindowProc(518, wParam, lParam);
        }
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_RBUTTONDOWN(int wParam, int lParam) {
        return this.sendMouseDownEvent(3, 3, 516, wParam, lParam);
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        int count = OS.SendMessage(this.handle, 4100, 0, 0);
        if (count == 0) {
            return result;
        }
        int index = OS.SendMessage(this.handle, 4108, -1, 1);
        if (index == -1) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 8;
            lvItem.state = 1;
            lvItem.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lvItem);
            this.ignoreSelect = false;
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        if (this.ignoreResize) {
            this.ignoreResize = false;
            int code = this.callWindowProc(5, wParam, lParam);
            return new LRESULT(code);
        }
        return super.WM_SIZE(wParam, lParam);
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageListColor();
        }
        return result;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        switch (hdr.code) {
            case -12: {
                if (!this.customDraw) break;
                NMLVCUSTOMDRAW nmcd = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, 60);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return new LRESULT(32);
                    }
                    case 65537: {
                        return new LRESULT(32);
                    }
                    case 196609: {
                        TableItem item = this.items[nmcd.dwItemSpec];
                        int clrText = item.foreground;
                        int clrTextBk = item.background;
                        if (clrText == -1 && clrTextBk == -1) break;
                        nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                        nmcd.clrTextBk = clrTextBk == -1 ? this.getBackgroundPixel() : clrTextBk;
                        OS.MoveMemory(lParam, nmcd, 60);
                        return new LRESULT(2);
                    }
                }
                break;
            }
            case -156: {
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                this.dragStarted = true;
                if (hdr.code != -109) break;
                this.postEvent(29);
                break;
            }
            case -108: {
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                TableColumn column = this.columns[pnmlv.iSubItem];
                if (column == null) break;
                column.postEvent(13);
                break;
            }
            case -114: {
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                if (pnmlv.iItem == -1) break;
                Event event = new Event();
                event.item = this.items[pnmlv.iItem];
                this.postEvent(14, event);
                break;
            }
            case -101: {
                if (this.ignoreSelect) break;
                NMLISTVIEW pnmlv = new NMLISTVIEW();
                OS.MoveMemory(pnmlv, lParam, NMLISTVIEW.sizeof);
                if (pnmlv.iItem == -1 || (pnmlv.uChanged & 8) == 0) break;
                int oldBits = pnmlv.uOldState & 0xF000;
                int newBits = pnmlv.uNewState & 0xF000;
                if (oldBits != newBits) {
                    Event event = new Event();
                    event.item = this.items[pnmlv.iItem];
                    event.detail = 32;
                    this.postEvent(13, event);
                    break;
                }
                boolean isFocus = (pnmlv.uNewState & 1) != 0;
                int index = OS.SendMessage(this.handle, 4108, -1, 1);
                if ((this.style & 2) != 0 && OS.GetKeyState(17) < 0) {
                    if (!isFocus) {
                        if (index == pnmlv.iItem) {
                            boolean isSelected = (pnmlv.uNewState & 2) != 0;
                            boolean wasSelected = (pnmlv.uOldState & 2) != 0;
                            isFocus = isSelected != wasSelected;
                        }
                    } else {
                        isFocus = this.mouseDown;
                    }
                }
                if (OS.GetKeyState(32) < 0) {
                    isFocus = true;
                }
                if (!isFocus) break;
                Event event = new Event();
                if (index != -1) {
                    event.item = this.items[index];
                }
                this.postEvent(13, event);
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }

    LRESULT wmScroll(int msg, int wParam, int lParam) {
        int code = this.callWindowProc(msg, wParam, lParam);
        if (code == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }
}

