/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTOOLBAR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int lastFocusId;
    ToolItem[] items;
    boolean ignoreResize;
    ImageList imageList;
    ImageList disabledImageList;
    ImageList hotImageList;
    static final int ToolBarProc;
    static final TCHAR ToolBarClass;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;

    static {
        ToolBarClass = new TCHAR(0, "ToolbarWindow32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, ToolBarClass, lpWndClass);
        ToolBarProc = lpWndClass.lpfnWndProc;
    }

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        if (msg == 262) {
            return OS.DefWindowProc(this.handle, msg, wParam, lParam);
        }
        return OS.CallWindowProc(ToolBarProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        if ((style & 0x800000) == 0) {
            style |= 0x80000;
        }
        if ((style & 0x200) != 0) {
            style |= 0x40;
        }
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (this.layout != null) {
            return super.computeSize(wHint, hHint, changed);
        }
        int width = 0;
        int height = 0;
        RECT oldRect = new RECT();
        OS.GetWindowRect(this.handle, oldRect);
        int oldWidth = oldRect.right - oldRect.left;
        int oldHeight = oldRect.bottom - oldRect.top;
        int newWidth = wHint;
        int newHeight = hHint;
        if (newWidth == -1) {
            newWidth = 16383;
        }
        if (newHeight == -1) {
            newHeight = 16383;
        }
        this.ignoreResize = true;
        int flags = 30;
        OS.SetWindowPos(this.handle, 0, 0, 0, newWidth, newHeight, flags);
        int count = OS.SendMessage(this.handle, 1048, 0, 0);
        if (count != 0) {
            RECT rect = new RECT();
            OS.SendMessage(this.handle, 1053, count - 1, rect);
            width = Math.max(width, rect.right);
            height = Math.max(height, rect.bottom);
        }
        OS.SetWindowPos(this.handle, 0, 0, 0, oldWidth, oldHeight, flags);
        this.ignoreResize = false;
        if (width == 0) {
            width = 24;
        }
        if (height == 0) {
            height = 22;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x40) == 0) {
            trim.height += 2;
        }
        return trim;
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFEFFF;
        int hwndToolTip = OS.SendMessage(this.handle, 1059, 0, 0);
        Display display = this.getDisplay();
        int flags = 19;
        display.lockActiveWindow = true;
        OS.SetWindowPos(hwndToolTip, -1, 0, 0, 0, 0, flags);
        display.lockActiveWindow = false;
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
        OS.SendMessage(this.handle, 1054, 20, 0);
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
        int bits = 1;
        OS.SendMessage(this.handle, 1108, 0, bits);
    }

    void createItem(ToolItem item, int index) {
        int count = OS.SendMessage(this.handle, 1048, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            ToolItem[] newItems = new ToolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        int bits = item.widgetStyle();
        TBBUTTON lpButton = new TBBUTTON();
        lpButton.idCommand = id;
        lpButton.fsStyle = (byte)bits;
        lpButton.fsState = (byte)4;
        if ((bits & 1) == 0) {
            lpButton.iBitmap = -2;
        }
        if (OS.SendMessage(this.handle, OS.TB_INSERTBUTTON, index, lpButton) == 0) {
            this.error(14);
        }
        item.id = id;
        this.items[item.id] = item;
        this.layoutItems();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.lastFocusId = -1;
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    void destroyItem(ToolItem item) {
        TBBUTTONINFO info = new TBBUTTONINFO();
        info.cbSize = 32;
        info.dwMask = 9;
        int index = OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, item.id, info);
        if ((info.fsStyle & 1) == 0 && info.iImage != -2) {
            if (this.imageList != null) {
                this.imageList.put(info.iImage, null);
            }
            if (this.hotImageList != null) {
                this.hotImageList.put(info.iImage, null);
            }
            if (this.disabledImageList != null) {
                this.disabledImageList.put(info.iImage, null);
            }
        }
        OS.SendMessage(this.handle, 1046, index, 0);
        if (item.id == this.lastFocusId) {
            this.lastFocusId = -1;
        }
        this.items[item.id] = null;
        item.id = -1;
        int count = OS.SendMessage(this.handle, 1048, 0, 0);
        if (count == 0) {
            Display display = this.getDisplay();
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 1072, 0, 0);
                display.releaseToolImageList(this.imageList);
            }
            if (this.hotImageList != null) {
                OS.SendMessage(this.handle, 1076, 0, 0);
                display.releaseToolHotImageList(this.hotImageList);
            }
            if (this.disabledImageList != null) {
                OS.SendMessage(this.handle, 1078, 0, 0);
                display.releaseToolDisabledImageList(this.disabledImageList);
            }
            this.disabledImageList = null;
            this.hotImageList = null;
            this.imageList = null;
            this.items = new ToolItem[4];
        }
        this.layoutItems();
    }

    ImageList getDisabledImageList() {
        return this.disabledImageList;
    }

    ImageList getHotImageList() {
        return this.hotImageList;
    }

    ImageList getImageList() {
        return this.imageList;
    }

    public ToolItem getItem(int index) {
        TBBUTTON lpButton;
        int result;
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1048, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((result = OS.SendMessage(this.handle, 1047, index, lpButton = new TBBUTTON())) == 0) {
            this.error(8);
        }
        return this.items[lpButton.idCommand];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Rectangle rect = items[i].getBounds();
            if (rect.contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1048, 0, 0);
        TBBUTTON lpButton = new TBBUTTON();
        ToolItem[] result = new ToolItem[count];
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, 1047, i, lpButton);
            result[i] = this.items[lpButton.idCommand];
            ++i;
        }
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1064, 0, 0);
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1049, item.id, 0);
    }

    void layoutItems() {
        int i = 0;
        while (i < this.items.length) {
            ToolItem item = this.items[i];
            if (item != null) {
                item.resizeControl();
            }
            ++i;
        }
    }

    boolean mnemonicHit(char ch) {
        int[] id;
        int key = this.wcsToMbcs(ch);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, key, id = new int[1]) == 0) {
            return false;
        }
        if (!this.setTabGroupFocus()) {
            return false;
        }
        int index = OS.SendMessage(this.handle, 1049, id[0], 0);
        if (index == -1) {
            return false;
        }
        OS.SendMessage(this.handle, 1096, index, 0);
        this.items[id[0]].click(false);
        return true;
    }

    boolean mnemonicMatch(char ch) {
        int[] id;
        int key = this.wcsToMbcs(ch);
        return OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, key, id = new int[1]) != 0;
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.items.length) {
            ToolItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseImages();
                item.releaseWidget();
            }
            ++i;
        }
        this.items = null;
        Display display = this.getDisplay();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 1072, 0, 0);
            display.releaseToolImageList(this.imageList);
        }
        if (this.hotImageList != null) {
            OS.SendMessage(this.handle, 1076, 0, 0);
            display.releaseToolHotImageList(this.hotImageList);
        }
        if (this.disabledImageList != null) {
            OS.SendMessage(this.handle, 1078, 0, 0);
            display.releaseToolDisabledImageList(this.disabledImageList);
        }
        this.disabledImageList = null;
        this.hotImageList = null;
        this.imageList = null;
        super.releaseWidget();
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if (this.parent.hdwp != 0 && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
            int oldHdwp = this.parent.hdwp;
            this.parent.hdwp = 0;
            OS.EndDeferWindowPos(oldHdwp);
            int count = this.parent.getChildrenCount();
            this.parent.hdwp = OS.BeginDeferWindowPos(count);
        }
        super.setBounds(x, y, width, height, flags);
    }

    void setDefaultFont() {
        super.setDefaultFont();
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
    }

    void setDisabledImageList(ImageList imageList) {
        if (this.disabledImageList == imageList) {
            return;
        }
        int hImageList = 0;
        this.disabledImageList = imageList;
        if (this.disabledImageList != null) {
            hImageList = this.disabledImageList.getHandle();
        }
        OS.SendMessage(this.handle, 1078, 0, hImageList);
    }

    void setHotImageList(ImageList imageList) {
        if (this.hotImageList == imageList) {
            return;
        }
        int hImageList = 0;
        this.hotImageList = imageList;
        if (this.hotImageList != null) {
            hImageList = this.hotImageList.getHandle();
        }
        OS.SendMessage(this.handle, 1076, 0, hImageList);
    }

    void setImageList(ImageList imageList) {
        if (this.imageList == imageList) {
            return;
        }
        int hImageList = 0;
        this.imageList = imageList;
        if (this.imageList != null) {
            hImageList = imageList.getHandle();
        }
        OS.SendMessage(this.handle, 1072, 0, hImageList);
    }

    boolean setTabItemFocus() {
        int index = 0;
        while (index < this.items.length) {
            ToolItem item = this.items[index];
            if (item != null && (item.style & 2) == 0 && item.getEnabled()) break;
            ++index;
        }
        if (index == this.items.length) {
            return false;
        }
        return super.setTabItemFocus();
    }

    int toolTipHandle() {
        return OS.SendMessage(this.handle, 1059, 0, 0);
    }

    String toolTipText(NMTTDISPINFO hdr) {
        ToolItem item;
        if ((hdr.uFlags & 1) != 0) {
            return null;
        }
        int index = hdr.idFrom;
        int hwndToolTip = this.toolTipHandle();
        if (hwndToolTip == hdr.hwndFrom && index >= 0 && index < this.items.length && (item = this.items[index]) != null) {
            return item.toolTipText;
        }
        return super.toolTipText(hdr);
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40 | 4 | 0x100;
        if ((this.style & 0x40) != 0) {
            bits |= 0x200;
        }
        if ((this.style & 0x800000) != 0) {
            bits |= 0x800;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 0x1000;
        }
        return bits;
    }

    TCHAR windowClass() {
        return ToolBarClass;
    }

    int windowProc() {
        return ToolBarProc;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return new LRESULT(8192);
    }

    LRESULT WM_COMMAND(int wParam, int lParam) {
        LRESULT result = super.WM_COMMAND(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 13: 
            case 32: {
                TBBUTTON lpButton;
                int code;
                int index = OS.SendMessage(this.handle, 1095, 0, 0);
                if (index == -1 || (code = OS.SendMessage(this.handle, 1047, index, lpButton = new TBBUTTON())) == 0) break;
                this.items[lpButton.idCommand].click(wParam == 13);
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        TBBUTTON lpButton;
        int index = OS.SendMessage(this.handle, 1095, 0, 0);
        int code = OS.SendMessage(this.handle, 1047, index, lpButton = new TBBUTTON());
        if (code != 0) {
            this.lastFocusId = lpButton.idCommand;
        }
        return super.WM_KILLFOCUS(wParam, lParam);
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        LRESULT result = super.WM_NOTIFY(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if (this.lastFocusId != -1 && this.handle == OS.GetFocus()) {
            int index = OS.SendMessage(this.handle, 1049, this.lastFocusId, 0);
            OS.SendMessage(this.handle, 1096, index, 0);
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        if (this.ignoreResize) {
            int code = this.callWindowProc(5, wParam, lParam);
            if (code == 0) {
                return LRESULT.ZERO;
            }
            return new LRESULT(code);
        }
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result;
        }
        this.layoutItems();
        return result;
    }

    LRESULT WM_WINDOWPOSCHANGING(int wParam, int lParam) {
        LRESULT result = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.drawCount != 0) {
            return result;
        }
        if ((this.style & 0x40) == 0) {
            return result;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return result;
        }
        if (OS.SendMessage(this.handle, 1064, 0, 0) == 1) {
            return result;
        }
        WINDOWPOS lpwp = new WINDOWPOS();
        OS.MoveMemory(lpwp, lParam, 28);
        if ((lpwp.flags & 9) != 0) {
            return result;
        }
        RECT oldRect = new RECT();
        OS.GetClientRect(this.handle, oldRect);
        RECT newRect = new RECT();
        OS.SetRect(newRect, 0, 0, lpwp.cx, lpwp.cy);
        OS.SendMessage(this.handle, 131, 0, newRect);
        int oldWidth = oldRect.right - oldRect.left;
        int newWidth = newRect.right - newRect.left;
        if (newWidth > oldWidth) {
            RECT rect = new RECT();
            rect.left = oldWidth - 2;
            rect.right = oldWidth;
            rect.bottom = newRect.bottom - newRect.top;
            OS.InvalidateRect(this.handle, rect, false);
        }
        return result;
    }

    LRESULT wmCommandChild(int wParam, int lParam) {
        ToolItem child = this.items[wParam & 0xFFFF];
        if (child == null) {
            return null;
        }
        return child.wmCommandChild(wParam, lParam);
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        switch (hdr.code) {
            case -710: {
                NMTOOLBAR lpnmtb = new NMTOOLBAR();
                OS.MoveMemory(lpnmtb, lParam, NMTOOLBAR.sizeof);
                ToolItem child = this.items[lpnmtb.iItem];
                if (child == null) break;
                Event event = new Event();
                event.detail = 4;
                child.postEvent(13, event);
                return null;
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

