/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    Display display;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    int resizeCursor;
    int clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
        this.display = parent.getDisplay();
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(10, typedListener);
    }

    Point adjustMoveCursor() {
        Rectangle bounds = this.computeBounds();
        int newX = bounds.x + bounds.width / 2;
        int newY = bounds.y;
        POINT pt = new POINT();
        pt.x = newX;
        pt.y = newY;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pt);
        }
        OS.SetCursorPos(pt.x, pt.y);
        return new Point(pt.x, pt.y);
    }

    Point adjustResizeCursor() {
        Rectangle bounds = this.computeBounds();
        int newX = (this.cursorOrientation & 0x4000) != 0 ? bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? bounds.x + bounds.width : bounds.x + bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? bounds.y : ((this.cursorOrientation & 0x400) != 0 ? bounds.y + bounds.height : bounds.y + bounds.height / 2);
        POINT pt = new POINT();
        pt.x = newX;
        pt.y = newY;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pt);
        }
        OS.SetCursorPos(pt.x, pt.y);
        if (this.clientCursor == 0) {
            int newCursor = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = OS.LoadCursor(0, 32645);
                    break;
                }
                case 1024: {
                    newCursor = OS.LoadCursor(0, 32645);
                    break;
                }
                case 16384: {
                    newCursor = OS.LoadCursor(0, 32644);
                    break;
                }
                case 131072: {
                    newCursor = OS.LoadCursor(0, 32644);
                    break;
                }
                case 16512: {
                    newCursor = OS.LoadCursor(0, 32642);
                    break;
                }
                case 132096: {
                    newCursor = OS.LoadCursor(0, 32642);
                    break;
                }
                case 17408: {
                    newCursor = OS.LoadCursor(0, 32643);
                    break;
                }
                case 131200: {
                    newCursor = OS.LoadCursor(0, 32643);
                    break;
                }
                default: {
                    newCursor = OS.LoadCursor(0, 32646);
                }
            }
            OS.SetCursor(newCursor);
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
            }
            this.resizeCursor = newCursor;
        }
        return new Point(pt.x, pt.y);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        Rectangle bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            result[i] = new Rectangle((rects[i].x - bounds.x) * 100 / bounds.width, (rects[i].y - bounds.y) * 100 / bounds.height, rects[i].width * 100 / bounds.width, rects[i].height * 100 / bounds.height);
            ++i;
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
        int bandWidth = 1;
        int hwndTrack = OS.GetDesktopWindow();
        if (this.parent != null) {
            hwndTrack = this.parent.handle;
        }
        int hDC = OS.GetDCEx(hwndTrack, 0, 2);
        int hBitmap = 0;
        int hBrush = 0;
        int oldBrush = 0;
        if (this.stippled) {
            bandWidth = 3;
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] bits = byArray;
            hBitmap = OS.CreateBitmap(8, 8, 1, 1, bits);
            hBrush = OS.CreatePatternBrush(hBitmap);
            oldBrush = OS.SelectObject(hDC, hBrush);
        }
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            OS.PatBlt(hDC, rect.x, rect.y, rect.width, bandWidth, 5898313);
            OS.PatBlt(hDC, rect.x, rect.y + bandWidth, bandWidth, rect.height - bandWidth * 2, 5898313);
            OS.PatBlt(hDC, rect.x + rect.width - bandWidth, rect.y + bandWidth, bandWidth, rect.height - bandWidth * 2, 5898313);
            OS.PatBlt(hDC, rect.x, rect.y + rect.height - bandWidth, rect.width, bandWidth, 5898313);
            ++i;
        }
        if (this.stippled) {
            OS.SelectObject(hDC, oldBrush);
            OS.DeleteObject(hBrush);
            OS.DeleteObject(hBitmap);
        }
        OS.ReleaseDC(hwndTrack, hDC);
    }

    public Display getDisplay() {
        return this.display;
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        return this.rectangles;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            return;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            return;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            return;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            return;
        }
        Rectangle bounds = this.computeBounds();
        bounds.x += xChange;
        bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        Point cursorPos;
        boolean mouseDown;
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        boolean cancelled = false;
        this.tracking = true;
        Event event = new Event();
        MSG msg = new MSG();
        int hwndTransparent = 0;
        Callback newProc = null;
        boolean bl = mouseDown = OS.GetKeyState(1) < 0;
        if (!mouseDown) {
            int width = OS.GetSystemMetrics(0);
            int height = OS.GetSystemMetrics(1);
            hwndTransparent = OS.CreateWindowEx(32, this.display.windowClass, null, -1879048192, 0, 0, width, height, 0, 0, OS.GetModuleHandle(null), null);
            final int oldProc = OS.GetWindowLong(hwndTransparent, -4);
            Object windowProc = new Object(){

                public int windowProc(int hwnd, int msg, int wParam, int lParam) {
                    switch (msg) {
                        case 132: {
                            if (!Tracker.this.inEvent) break;
                            return -1;
                        }
                        case 32: {
                            if (Tracker.this.clientCursor != 0) {
                                OS.SetCursor(Tracker.this.clientCursor);
                                return 1;
                            }
                            if (Tracker.this.resizeCursor == 0) break;
                            OS.SetCursor(Tracker.this.resizeCursor);
                            return 1;
                        }
                    }
                    return OS.CallWindowProc(oldProc, hwnd, msg, wParam, lParam);
                }
            };
            newProc = new Callback(windowProc, "windowProc", 4);
            OS.SetWindowLong(hwndTransparent, -4, newProc.getAddress());
        }
        this.drawRectangles(this.rectangles);
        if (mouseDown) {
            POINT pt = new POINT();
            OS.GetCursorPos(pt);
            cursorPos = new Point(pt.x, pt.y);
        } else {
            cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
        }
        int oldX = cursorPos.x;
        int oldY = cursorPos.y;
        while (this.tracking && !cancelled) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.GetMessage(msg, 0, 0, 0);
            int message = msg.message;
            switch (message) {
                case 512: 
                case 514: {
                    int newPos = OS.GetMessagePos();
                    int newX = newPos & 0xFFFF;
                    int newY = newPos >> 16;
                    if (newX != oldX || newY != oldY) {
                        this.drawRectangles(this.rectangles);
                        event.x = newX;
                        event.y = newY;
                        if ((this.style & 0x10) != 0) {
                            this.resizeRectangles(newX - oldX, newY - oldY);
                            cursorPos = this.adjustResizeCursor();
                            newX = cursorPos.x;
                            newY = cursorPos.y;
                            this.inEvent = true;
                            this.sendEvent(11, event);
                        } else {
                            this.moveRectangles(newX - oldX, newY - oldY);
                            this.inEvent = true;
                            this.sendEvent(10, event);
                        }
                        this.inEvent = false;
                        if (this.isDisposed()) {
                            return false;
                        }
                        this.drawRectangles(this.rectangles);
                        oldX = newX;
                        oldY = newY;
                    }
                    this.tracking = msg.message != 514;
                    break;
                }
                case 260: {
                    cancelled = true;
                    this.tracking = false;
                    break;
                }
                case 256: {
                    int stepSize = OS.GetKeyState(17) < 0 ? 1 : 9;
                    int xChange = 0;
                    int yChange = 0;
                    switch (msg.wParam) {
                        case 27: {
                            cancelled = true;
                            this.tracking = false;
                            break;
                        }
                        case 13: {
                            this.tracking = false;
                            break;
                        }
                        case 37: {
                            xChange = -stepSize;
                            break;
                        }
                        case 39: {
                            xChange = stepSize;
                            break;
                        }
                        case 38: {
                            yChange = -stepSize;
                            break;
                        }
                        case 40: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) break;
                    this.drawRectangles(this.rectangles);
                    int newX = oldX + xChange;
                    int newY = oldY + yChange;
                    event.x = newX;
                    event.y = newY;
                    if ((this.style & 0x10) != 0) {
                        this.resizeRectangles(xChange, yChange);
                        cursorPos = this.adjustResizeCursor();
                        this.inEvent = true;
                        this.sendEvent(11, event);
                    } else {
                        this.moveRectangles(xChange, yChange);
                        cursorPos = this.adjustMoveCursor();
                        this.inEvent = true;
                        this.sendEvent(10, event);
                    }
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        return false;
                    }
                    this.drawRectangles(this.rectangles);
                    oldX = cursorPos.x;
                    oldY = cursorPos.y;
                }
            }
            if (this.tracking && !cancelled && (256 <= message && message <= 264 || 512 <= message && message <= 525)) continue;
            OS.DispatchMessage(msg);
        }
        this.drawRectangles(this.rectangles);
        if (hwndTransparent != 0) {
            OS.DestroyWindow(hwndTransparent);
        }
        if (newProc != null) {
            newProc.dispose();
        }
        if (this.resizeCursor != 0) {
            OS.DestroyCursor(this.resizeCursor);
        }
        this.tracking = false;
        return !cancelled;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        Rectangle bounds = this.computeBounds();
        if ((this.cursorOrientation & 0x4000) != 0) {
            bounds.x += xChange;
            bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            bounds.y += yChange;
            bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            bounds.height += yChange;
        }
        if (bounds.width < 0 || bounds.height < 0) {
            return;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle proportion = this.proportions[i];
            newRects[i] = new Rectangle(proportion.x * bounds.width / 100 + bounds.x, proportion.y * bounds.height / 100 + bounds.y, proportion.width * bounds.width / 100, proportion.height * bounds.height / 100);
            ++i;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = 0;
        if (newCursor != null) {
            this.clientCursor = newCursor.handle;
            if (this.inEvent) {
                OS.SetCursor(this.clientCursor);
            }
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        this.rectangles = rectangles;
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

