/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.ra;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import tle.framework.component.spi.ra.FileItem;
import tle.framework.component.spi.ra.RequestInfo;

public class DefaultRequestInfo
implements RequestInfo {
    private String commandID;
    private Map parameterMap = new HashMap();
    private Map fileMap = new HashMap();
    private Map cookieMap = new HashMap();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public DefaultRequestInfo(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
    }

    void setCommandID(String commandID) {
        this.commandID = commandID;
    }

    public String getCommandID() {
        return this.commandID;
    }

    void addParameter(String name, String[] values) {
        this.parameterMap.put(name, values);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameterMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameterMap.get(name);
    }

    public String[] getParameterNames() {
        String[] names = new String[this.parameterMap.size()];
        this.parameterMap.keySet().toArray(names);
        return names;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getCookieValue(String name) {
        Cookie cookie = (Cookie)this.cookieMap.get(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public Cookie getCookie(String name) {
        return (Cookie)this.cookieMap.get(name);
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public Map getCookieMap() {
        return Collections.unmodifiableMap(this.cookieMap);
    }

    void addFileItem(String name, FileItem fileItem) {
        this.fileMap.put(name, fileItem);
    }

    public FileItem getFileItem(String name) {
        return (FileItem)this.fileMap.get(name);
    }

    public byte[] getFileByBytes(String name) throws Throwable {
        FileItem fileItem = this.getFileItem(name);
        if (fileItem == null) {
            return null;
        }
        return fileItem.getBytes();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.request.getSession(false);
    }

    public FileItem[] getFileItems() {
        Collection coll = this.fileMap.values();
        FileItem[] items = new FileItem[coll.size()];
        coll.toArray(items);
        return items;
    }
}

