/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.rp;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.rp.DefaultRequestProcessorMBean;
import tle.framework.component.impl.rp.DefaultResult;
import tle.framework.component.impl.rp.RequestProcessorElementFactory;
import tle.framework.component.impl.rp.config.CommandMappingConfig;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.DefaultRPConfigurationDigester;
import tle.framework.component.impl.rp.config.FormConfig;
import tle.framework.component.impl.rp.config.FormTestConfig;
import tle.framework.component.impl.rp.handler.CommandHandler;
import tle.framework.component.impl.rp.handler.JSPCommandHandler;
import tle.framework.component.impl.rp.handler.NoHandlerCommandHandler;
import tle.framework.component.impl.rp.validator.Validator;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.RequestProcessor;
import tle.framework.component.spi.rp.Result;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

public class DefaultRequestProcessor
extends ComponentBase
implements RequestProcessor,
DefaultRequestProcessorMBean {
    private RequestProcessorElementFactory elementFactory;
    private String configFilePath;
    private DefaultRPConfiguration configuration;

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public boolean isUsingHandlerIndependentClassPath() {
        return this.configuration.isUsingIndependentClassPath();
    }

    public String[] getHandlerIndependentClassPath() {
        return this.configuration.getClassPathArray();
    }

    public void reloadHandlerClasses() throws ComponentException {
        if (!this.configuration.isUsingIndependentClassPath()) {
            throw new UnsupportedOperationException("usingHandlerIndependentClassPath != true");
        }
        this.elementFactory.reloadHandlerClasses(this.configuration);
    }

    public void reloadConfiguration() throws ComponentException {
        try {
            DefaultRPConfiguration newConfiguration;
            this.configuration = newConfiguration = DefaultRPConfigurationDigester.create(TLEConfigPathUtil.replace(this.configFilePath));
        }
        catch (Throwable e) {
            Logger.fatal("DefaultRequestProcessor.reloadConfiguration():Configuration File Loading Error", e);
            throw new ComponentException(e.getMessage(), e);
        }
        this.elementFactory.init(this.configuration);
    }

    protected void initing(ComponentConfig config) throws ComponentException {
        this.configFilePath = config.getInitParameter("configFile");
        if (this.configFilePath == null) {
            this.configFilePath = System.getProperty("user.home") + File.separator + "DefaultRequestProcessor.xml";
        }
        try {
            this.configuration = DefaultRPConfigurationDigester.create(TLEConfigPathUtil.replace(this.configFilePath));
        }
        catch (Throwable e) {
            Logger.fatal("DefaultRequestProcessor.initing():Configuration File Loading Error", e);
            throw new ComponentException(e.getMessage(), e);
        }
        this.elementFactory = new RequestProcessorElementFactory(this.configuration);
    }

    public Result process(RequestInfo ri) throws ComponentException {
        CommandHandler handler;
        FormConfig[] formConfigs;
        CommandMappingConfig mappingConfig = this.elementFactory.createCommandMappingConfig(ri);
        ArrayList<String> formErrorMessageList = null;
        String formErrorResultCode = null;
        if (mappingConfig != null && mappingConfig.getFormName() != null && (formConfigs = this.configuration.getFormConfigs(mappingConfig.getFormName())).length > 0) {
            String[] errorResultCodes = DefaultRPConfiguration.split(mappingConfig.getFormErrorResultCode(), ',', true, true);
            if (errorResultCodes.length == 0) {
                errorResultCodes = new String[formConfigs.length];
            }
            for (int formIdx = 0; formIdx < formConfigs.length; ++formIdx) {
                FormConfig formConfig = formConfigs[formIdx];
                if (formConfig == null || formConfig.getFormTestConfigList().size() <= 0) continue;
                List formTestConfigList = formConfig.getFormTestConfigList();
                for (int i = 0; i < formTestConfigList.size(); ++i) {
                    FormTestConfig formTestConfig = (FormTestConfig)formTestConfigList.get(i);
                    Validator validator = this.elementFactory.createValitor(formTestConfig.getValidatorName());
                    boolean isValid = validator.test(ri.getParameterValues(formTestConfig.getParameterName()), formTestConfig.getConstraint());
                    if (isValid) continue;
                    if (formErrorMessageList == null) {
                        formErrorMessageList = new ArrayList<String>(8);
                    }
                    formErrorMessageList.add(formTestConfig.getErrrorMessage());
                }
                if (formErrorMessageList == null || formErrorMessageList.size() <= 0) continue;
                formErrorResultCode = errorResultCodes[formIdx] == null ? "" : errorResultCodes[formIdx];
                break;
            }
        }
        if ((handler = this.elementFactory.createCommandHandler(ri)) instanceof NoHandlerCommandHandler) {
            throw new ComponentException("NO HANDLER:" + ri.getCommandID());
        }
        DefaultResult result = new DefaultResult(ri.getCommandID());
        boolean goHandler = false;
        if (formErrorMessageList != null && formErrorMessageList.size() > 0) {
            for (int i = 0; i < formErrorMessageList.size(); ++i) {
                result.addErrorMessage((String)formErrorMessageList.get(i));
            }
            if (formErrorResultCode == null || formErrorResultCode.equals("")) {
                goHandler = true;
            } else {
                result.setCode(formErrorResultCode);
            }
        } else {
            goHandler = true;
        }
        if (goHandler) {
            result.setRequestInfo(ri);
            try {
                result = handler.process(ri, result);
            }
            catch (Throwable e) {
                throw new ComponentException(e.getMessage(), e);
            }
        }
        return result;
    }

    public String getHandlerIDForCommandID(String commandID) {
        return this.elementFactory.getHandlerIDForCommandID(commandID);
    }

    public String getHandlerFullName(String handlerID) {
        CommandHandler handler = this.elementFactory.getCommandHandler(handlerID);
        if (handler == null) {
            return null;
        }
        if (handler instanceof JSPCommandHandler) {
            return ((JSPCommandHandler)handler).getHandlerJSPPage();
        }
        return handler.getClass().getName();
    }

    public boolean isUseDefaultOnInvalidMapping() {
        return this.configuration.isUseDefaultOnInvalidMapping();
    }
}

