/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import tle.framework.component.spi.ra.RequestInfo;

public class RIRequestWrapper
extends HttpServletRequestWrapper {
    private RequestInfo ri = null;

    public RIRequestWrapper(HttpServletRequest request, RequestInfo ri) {
        super(request);
        this.ri = ri;
    }

    public String getParameter(String name) {
        String value = this.ri.getParameter(name);
        if (value == null) {
            value = super.getRequest().getParameter(name);
        }
        return value;
    }

    public Map getParameterMap() {
        Map superMap = super.getRequest().getParameterMap();
        HashMap<String, String[]> thisMap = new HashMap<String, String[]>();
        thisMap.putAll(superMap);
        String[] names = this.ri.getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            thisMap.put(names[i], this.ri.getParameterValues(names[i]));
        }
        return Collections.unmodifiableMap(thisMap);
    }

    public Enumeration getParameterNames() {
        Map paramMap = this.getParameterMap();
        ArrayList list = new ArrayList();
        list.addAll(paramMap.keySet());
        String[] names = new String[list.size()];
        list.toArray(names);
        return new EnemerationImpl(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this.ri.getParameterValues(name);
        if (values == null) {
            values = super.getRequest().getParameterValues(name);
        }
        return values;
    }

    private static class EnemerationImpl
    implements Enumeration {
        private int idx = 0;
        private String[] names;

        EnemerationImpl(String[] names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.idx < this.names.length;
        }

        public Object nextElement() {
            return this.names[this.idx++];
        }
    }
}

