/*
 * Ʈ: TLE2Framework
 * ϸ: UIConfigurationDigesterTest.java
 * ۼ: 2004. 11. 1
 */
package test.tle.framework.component.impl.uicreator.config;

import java.io.IOException;

import org.xml.sax.SAXException;

import tle.framework.component.impl.uicreator.config.CommandConfig;
import tle.framework.component.impl.uicreator.config.UIConfiguration;
import tle.framework.component.impl.uicreator.config.UIConfigurationDigester;
import tle.framework.component.impl.uicreator.config.ViewConfig;
import tle.framework.component.impl.uicreator.config.ViewSetConfig;
import junit.framework.TestCase;

/**
 * UIConfigurationDigester ׽Ʈ α׷
 * 
 * @author ֹ
 * @since 2.0
 */
public class UIConfigurationDigesterTest extends TestCase {

	public void testCreate() throws IOException, SAXException {
		UIConfiguration config = UIConfigurationDigester.create("c:/eclipse/workspace/TLE2Framework/config/DefaultUICreator.xml");
		ViewConfig viewConfig = null;
		ViewSetConfig viewSetConfig = config.getViewSetConfig("web");
		
		assertEquals("web", viewSetConfig.getViewSetID());
		assertEquals("loginForm", viewSetConfig.getAuthFormViewID());
		assertEquals("noGrant", viewSetConfig.getNoAuthViewID());
		assertEquals("error", viewSetConfig.getErrorViewID());

		viewConfig = viewSetConfig.getViewConfig("base");
		assertEquals("/web/template/template.jsp", viewConfig.getPage());

		viewConfig = viewSetConfig.getViewConfig("board");
		assertEquals("board", viewConfig.getViewID());
		assertEquals("base", viewConfig.getParentViewID());
		assertEquals("/web/board/list.jsp", viewConfig.getSubpage("content"));
		assertNull(viewConfig.getPage());

		viewConfig = viewSetConfig.getAuthFormViewConfig();
		assertEquals("loginForm", viewConfig.getViewID());
		assertEquals("/web/login/loginForm.jsp", viewConfig.getPage());
		assertNull(viewConfig.getParentViewID());

		viewConfig = viewSetConfig.getErrorViewConfig();
		assertEquals("error", viewConfig.getViewID());
		assertEquals("base", viewConfig.getParentViewID());
		assertEquals("/web/error/error.jsp", viewConfig.getSubpage("content"));
		assertNull(viewConfig.getPage());
		
		
		viewSetConfig = config.getViewSetConfig("pda");
		
		assertEquals("pda", viewSetConfig.getViewSetID());
		assertEquals("loginForm", viewSetConfig.getAuthFormViewID());
		assertEquals("noGrant", viewSetConfig.getNoAuthViewID());
		assertEquals("error", viewSetConfig.getErrorViewID());

		viewConfig = viewSetConfig.getViewConfig("base");
		assertEquals("/pda/template/template.jsp", viewConfig.getPage());

		viewConfig = viewSetConfig.getViewConfig("board");
		assertEquals("board", viewConfig.getViewID());
		assertEquals("base", viewConfig.getParentViewID());
		assertEquals("/pda/board/list.jsp", viewConfig.getSubpage("content"));
		assertNull(viewConfig.getPage());

		viewConfig = viewSetConfig.getAuthFormViewConfig();
		assertEquals("loginForm", viewConfig.getViewID());
		assertEquals("/pda/login/loginForm.jsp", viewConfig.getPage());
		assertNull(viewConfig.getParentViewID());

		viewConfig = viewSetConfig.getErrorViewConfig();
		assertEquals("error", viewConfig.getViewID());
		assertEquals("base", viewConfig.getParentViewID());
		assertEquals("/pda/error/error.jsp", viewConfig.getSubpage("content"));
		assertNull(viewConfig.getPage());
		
		CommandConfig commandConfig = null;
		commandConfig = config.getCommandConfig("/board.do");
		assertEquals("/board.do", commandConfig.getCommandID());
		
		commandConfig = config.getCommandConfig("/boardWrite.do");
		assertEquals("/boardWrite.do", commandConfig.getCommandID());
		assertEquals("boardWrite", commandConfig.getResultViewID("success"));
		assertEquals("noGrant", commandConfig.getResultViewID("fail"));
		
		assertEquals(true, config.hasGlobalResultPrefix());
		assertEquals("global.", config.getGlobalResultPrefix());
		assertEquals("invalidRequest", config.getGlobalResultMapping("invalidRequest"));
		assertEquals("noDataView", config.getGlobalResultMapping("noData"));
		
		
		viewSetConfig = config.getClientViewSetConfig("IE");
		assertEquals("web", viewSetConfig.getViewSetID());
		
		viewSetConfig = config.getClientViewSetConfig("PDA");
		assertEquals("pda", viewSetConfig.getViewSetID());
		
		viewSetConfig = config.getClientViewSetConfig("NETSCAPE");
		assertEquals("web", viewSetConfig.getViewSetID());

	}
}
