/*
 * Ʈ: TLE2Framework
 * ϸ: StateMachineTest.java
 * ۼ: 2004. 10. 13.
 */
package test.tle.framework.util.statemachine;

import tle.framework.util.statemachine.State;
import tle.framework.util.statemachine.StateMachine;
import junit.framework.TestCase;

/**
 * StateMachine ׽Ʈ Ŭ
 * 
 * @author ֹ
 * @since 2.0
 */
public class StateMachineTest extends TestCase {
	static State start = new StateMachine.StartState();
	static State finish = new StateMachine.FinishState();
	static State step1 = new State("1", new Integer(1));
	static State step2 = new State("2", new Integer(2));
	static StateMachine sm = null;
	
	static {
		start.addEvent("move", step1);
		step1.addEvent("recur", step1);
		step1.addEvent("go2", step2);
		step2.addEvent("go1", step1);
		step2.addEvent("finish", finish);
		
		sm = new StateMachine(start);
	}
	
	public void testIsStartState() {
		assertTrue(sm.isStartState());
	}

	public void testTransition() {
		sm.transit("move");
		assertEquals(sm.getCurrentState().getStateName(), "1");
		assertEquals(sm.getCurrentState().getStateValue(), new Integer(1));
		
		sm.transit("go2");
		assertEquals(sm.getCurrentState().getStateName(), "2");
		assertEquals(sm.getCurrentState().getStateValue(), new Integer(2));
		
		sm.transit("go1");
		assertEquals(sm.getCurrentState().getStateName(), "1");
		assertEquals(sm.getCurrentState().getStateValue(), new Integer(1));
		
		sm.transit("recur");
		assertEquals(sm.getCurrentState().getStateName(), "1");
		assertEquals(sm.getCurrentState().getStateValue(), new Integer(1));

		sm.transit("go2");
		sm.transit("finish");
	}

	public void testIsFinalState() {
		assertTrue(sm.isFinalState());
	}
}
