/*
 * Ʈ: TLE2Framework
 * ϸ: ComponentManager.java
 * ۼ: 2004. 10. 13
 */
package tle.framework;

import java.util.Iterator;
import java.util.Map;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;

import tle.framework.component.Component;
import tle.framework.component.ComponentAleadyExistsException;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentCreationException;
import tle.framework.component.ComponentException;
import tle.framework.component.ComponentNotFoundException;
import tle.framework.jmx.MBeanServerWrapper;
import tle.framework.log.Logger;

/**
 * Ʋ ӿũ  Ʈ Ѵ.
 * <p>
 * ComponentManager MBeanServerWrapper Ŭ ؼ Ʈ /Ѵ.
 * 
 * @author ֹ
 * @since 2.0 
 */
public class ComponentManager {
	/**
	 * ComponentManager singleton νϽ
	 */
	private static ComponentManager instance = new ComponentManager();
	
	/**
	 * ComponentManager singleton νϽ Ѵ.
	 * @return singleton νϽ
	 */
	static ComponentManager getInstance() {
		return instance;
	}
	
	private ComponentManager() {}
	
	/**
	 * &lt;ƮID, Component>  Ѵ.
	 */
	private Map componentMap = new java.util.HashMap();
	
	/**
	 *  ̵ Ʈ Ѵ.
	 * 
	 * @return
	 * @throws ComponentNotFoundException
	 */
	Component getComponent(String componentID) throws ComponentNotFoundException {
		Component component = (Component)componentMap.get(componentID);
		if (component == null) {
			throw new ComponentNotFoundException("Not Found Component:"+componentID);
		}
		return component;
	}
	
	/**
	 * ܺο   Ʈ Ѵ.
	 * <p>
	 * ϴ   .
	 * <ol>
	 *    <li>component.isCreate() ޼ҵ尡 true̸ component.init() ޼ҵ带 ȣϿ Ʈ ʱȭѴ.
	 *    <li>component.isInited() ޼ҵ尡 true̸ component.start() ޼ҵ带 ȣϿ Ʈ Ѵ.
	 * </ol>
	 * ,   ̹ Ʈ ʱȭǾ ִٸ ʱȭ  ݺ ʰ ٷ
	 * Ʈ Ѵٴ  ǹѴ.
	 *   
	 * @param component  Ʈ
	 * @param config ʱȭ 
	 */
	void registComponent(Component component, ComponentConfig config) throws ComponentException {
		try {
			if (component.isCreated()) {
				component.init(config);
				Logger.info("ComponentManager.registComponent():Component Inited :"+component.getID());
			}
			if (component.isInited()) {
				component.start();
				Logger.info("ComponentManager.registComponent():Component Running:"+component.getID());
			}
			
			MBeanServerWrapper.getInstance().registComponent(component);
			componentMap.put(component.getID(), component);
			
			Logger.info("ComponentManager.registComponent():Component Registered:"+component.getID());
		} catch (InstanceAlreadyExistsException e) {
			throw new ComponentAleadyExistsException(e.getMessage(), e);
		} catch (MBeanRegistrationException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (NotCompliantMBeanException e) {
			throw new ComponentCreationException(e.getMessage(), e);
		} catch (MalformedObjectNameException e) {
			throw new ComponentCreationException(e.getMessage(), e);
		}
	}
	
	/**
	 * Ʈ  κ Ʈ νϽ  , registComponent(Component, ComponentConfig)
	 * ޼ҵ带 ȣؼ Ʈ Ѵ.
	 * 
	 * @param config Ʈ  
	 */
	void registComponent(ComponentConfig config) throws ComponentException {
		String className = config.getComponentClass();
		try {
			// 1-Ŭκ Ʈ νϽ 
			Class componentClass = Class.forName(className);
			Component component = (Component)componentClass.newInstance();
			
			Logger.info("ComponentManager.registComponent():Component Created:"+config.getComponentID());
			
			registComponent(component, config);
		} catch (ClassNotFoundException e) {
			throw new ComponentCreationException(e.getMessage(), e);
		} catch (InstantiationException e) {
			throw new ComponentCreationException(e.getMessage(), e);
		} catch (IllegalAccessException e) {
			throw new ComponentCreationException(e.getMessage(), e);			
		}
	}
	
	/**
	 * Ʈ Ѵ.
	 * <p>
	 * Ʈ ̰ų    Ʈ ϰ  ڿ Ʈ Ѵ.
	 * Ʈ    .
	 * <ol>
	 *   <li>Ʈ ̰ų Ͻ ̸ Ʈ (stop) Ѵ.</li>
	 *   <li>Ʈ (close)Ѵ.</li>
	 *   <li>Ʈ MBeanServer Ѵ.</li>
	 * </ol>
	 * 
	 * @param componentId  Ʈ ID
	 */
	void unregistComponent(String componentID) throws ComponentException {
		Component component = (Component)componentMap.get(componentID);
		try {
			// 1-Ʈ 
			if (component.isRunning() || component.isSuspended()) {
				component.stop();
				Logger.info("ComponentManager.unregistComponent():Component Stopped:"+component.getID());
			}
			// 2-Ʈ 
			if (component.isStopped()) {
				component.close();
				Logger.info("ComponentManager.unregistComponent():Component Closed :"+component.getID());
			}
			// 3-Ʈ MBeanServer 
			MBeanServerWrapper.getInstance().unregistComponent(component);
			componentMap.remove(componentID);
			
			Logger.info("ComponentManager.unregistComponent():Component Removed:"+componentID);
			
		} catch (InstanceNotFoundException e) {
			throw new ComponentNotFoundException(e.getMessage(), e);
		} catch (MBeanRegistrationException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}
	
	/**
	 * ComponentManager ؼ ϵ  Ʈ Ѵ.
	 */
	void unregistAllComponent() {
		Iterator iter = componentMap.keySet().iterator();
		while(iter.hasNext()) {
			String componentID = (String)iter.next();
			try {
				unregistComponent(componentID);
			} catch (ComponentException e) {
				Logger.error("ComponentManager.unregistAllComponent():Fail to unregist Component:"+componentID, e);
			}
		}
	}
}
