/*
 * Ʈ: TLE2Framework
 * ϸ: TLEWebapplicationListener.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import tle.framework.log.Logger;

/**
 *  ø̼ ʷμ  ø̼ ʱȭ ǰų  
 * Ʋ ӿũ ʱȭϰų ش. web.xml Ͽ listenerμ  Ŭ ־ Ѵ.
 * <p>
 * web.xml  ؽƮ Ķ "tle.configFile" Ͽ Ʋ ӿũ ʱȭ   θ Ѵ.
 * <p>
 * web.xml Ͽ    ָ߰ ȴ.
 * 
 * <pre>
 *   &lt;context-param&gt;
 *       &lt;param-name&gt;tle.configFile&lt;/param-name&gt;
 *       &lt;param-value&gt;/home/webapps/tle2/WEB-INF/config/TLEFrameworkConfig.xml&lt;/param-value&gt;
 *   &lt;/context-param&gt;
 *   
 *   &lt;listener&gt;
 *       &lt;listener-class&gt;tle.framework.TLEWebapplicationListener&lt;/listener-class&gt;
 *   &lt;/listener&gt;
 * 
 * </pre>
 * 
 * tle.configFile ʱȭ Ķ    {context.path} {user.home}   ִ.
 * 
 * <pre>
 *   &lt;context-param&gt;
 *       &lt;param-name&gt;tle.configFile&lt;/param-name&gt;
 *       &lt;param-value&gt;{context.path}/WEB-INF/config/TLEFrameworkConfig.xml&lt;/param-value&gt;
 *   &lt;/context-param&gt;
 * </pre>
 * 
 * {context.path} ϰ Ǹ   ø̼ ΰ üǼ ,
 * {user.home} ϰ Ǹ  Ȩ丮 ΰ üǼ .
 * 
 * <p>
 *    Ŭ web.xml Ͽ listener   쿡  TLEFramework
 * ʱȭ  Ḧ ó־ Ѵ. 
 * <p>
 *  Ͽ   tle.framework.configuration.TLEConfig Ŭ   ִ.
 * 
 * @author ֹ
 * @since 2.0
 * @see tle.framework.configuration.TLEConfig
 * @see tle.framework.TLEFramework
 */
public class TLEWebapplicationListener implements ServletContextListener {

	/**
	 *  ø̼ ʱȭǸ TLEInitializer Ͽ Ʋ ӿũ  Ʈ ʱȭѴ.
	 * <p>
	 * TLEFramework.openFramework() ޼ҵ带 ȣѴ. ̶ tle.configFile ؽƮ Ķ 
	 * ڷ Ѵ.
	 * <p>
	 * TLEFramework.openFramework() ޼ҵ带 ȣϱ  
	 * TLEProperties.setProperty("context.path", 
	 *    event.getServletContext().getRealPath("")) ޼ҵ带 ȣѴ.
	 * 
	 * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.ServletContextEvent)
	 * @see tle.framework.TLEFramework#openFramework(java.lang.String configFilePath)
	 */
	public void contextInitialized(ServletContextEvent event) {
		if (Logger.isInfoEnabled()) Logger.info("TLEWebapplicationListener.contextInitialized():entry");
		
		String contextPath = event.getServletContext().getRealPath("");
		if (contextPath.endsWith("\\") || contextPath.endsWith("/")) {
			contextPath = contextPath.substring(0, contextPath.length() - 1);
		}
		TLEProperties.setProperty("context.path", contextPath);
		
		String configFilePath = event.getServletContext().getInitParameter("tle.configFile");
		try {
			TLEFramework.openFramework(configFilePath);
		} catch (TLEFrameworkException e) {
			Logger.fatal("TLEWebapplicationListener.contextInitialized():failed", e);
		}
		
		if (Logger.isInfoEnabled()) Logger.info("TLEWebapplicationListener.contextInitialized():exit");
	}
	
	/**
	 *  ø̼ Ǹ TLEInitializer Ͽ Ʋ ӿũ  Ʈ Ѵ.
	 * <p>
	 * TLEFramework.closeFramework() ޼ҵ带 ȣѴ.
	 * 
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
	 * @see tle.framework.TLEFramework#closeFramework()
	 */
	public void contextDestroyed(ServletContextEvent arg0) {
		if (Logger.isInfoEnabled()) Logger.info("TLEWebapplicationListener.contextDestroyed():entry");
		
		TLEFramework.closeFramework();
		
		if (Logger.isInfoEnabled()) Logger.info("TLEWebapplicationListener.contextDestroyed():exit");
	}
}