/*
 * Ʈ: TLE2Framework
 * ϸ: SessionManagerImpl.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import tle.framework.component.ComponentConfig;
import tle.framework.component.impl.aamanager.SessionManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.User;

/**
 * SessionManager  Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class SessionManagerImpl implements SessionManager {
	private String sessionAttributeName;
	
	/**
	 * Ʈ "SessionManagerImpl.sessionAttributeName" ʱȭ Ķͷκ
	 * User   session Ӽ ̸ ޹޴´.
	 *  ʾ 쿡 ⺻ "user" Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.SessionManager#init(tle.framework.component.ComponentConfig)
	 */
	public void init(ComponentConfig configuration) throws AAManagerException {
		sessionAttributeName = configuration.getInitParameter("SessionManagerImpl.sessionAttributeName");
		if (sessionAttributeName == null) {
			sessionAttributeName = "user";
		}
	}

	/**
	 * HttpSession ڷ ޹ user Ӽ Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.SessionManager#openSession(tle.framework.component.spi.aamanager.User, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void openSession(User user, HttpServletRequest request,
			HttpServletResponse response) {
		HttpSession session = request.getSession();
		session.setAttribute(sessionAttributeName, user);
	}

	/**
	 * HttpSession Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.SessionManager#closeSession(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void closeSession(HttpServletRequest request,
			HttpServletResponse response) throws AAManagerException {
		HttpSession session = request.getSession(false);
		if (session != null) {
			session.invalidate();
		}
	}

	/**
	 * HttpSession  User ü Ѵ.
	 *    null Ѵ.
	 * 
	 * @see tle.framework.component.impl.aamanager.SessionManager#getSessionUser(javax.servlet.http.HttpServletRequest)
	 */
	public User getSessionUser(HttpServletRequest request)
			throws AAManagerException {
		HttpSession session = request.getSession(false);
		if (session != null) {
			Object user = session.getAttribute(sessionAttributeName);
			if (user instanceof User) {
				return (User)user;
			}
		}
		return null;
	}
}
