/*
 * Ʈ: TLE2Framework
 * ϸ: ExactRegexValidator.java
 * ۼ: 2005. 6. 8
 */
package tle.framework.component.impl.rp.validator;

import org.apache.regexp.RE;

/**
 * Ķ   ǥ ϴ  θ ˻Ѵ.
 * RegexValidator  ǥ ϴ  Ķ  ԵǴ θ Ȯϴ ݸ鿡
 * ExactRegexValidator Ķ ü   ǥ ϴ  θ ȮѴ.
 * <p>
 * Jakarta Regexp API Ͽ ǥ óѴ.
 * @author ֹ
 * @since 2.0.5.6
 * @author ֹ
 */
public class ExactRegexValidator implements Validator {

	/**
	 * parameterValues[0]  ü ǥ constraint ϸ
	 * true Ѵ.
	 * <p>
	 * constraint null̸ true Ѵ.
	 * <p>
	 * parameterValues null̰ų
	 * parameterValues.length 0̰ų
	 * parameterValues[0]  null Ǵ ""̸ 
	 * true Ѵ.
	 * @see tle.framework.component.impl.rp.validator.Validator#test(java.lang.String[], java.lang.String)
	 */
	public boolean test(String[] parameterValues, String constraint) {
		if (parameterValues == null ||
				parameterValues.length == 0 ||
				parameterValues[0].equals(""))
			return true;
		
		RE re = new RE(constraint);
		if (re.match(parameterValues[0])) {
			return parameterValues[0].length() == re.getParenLength(0);
		}
		return false;
	}

}
