/*
 * Ʈ: TLE2Framework
 * ϸ: NumberValidator.java
 * ۼ: 2005. 6. 8
 */
package tle.framework.component.impl.rp.validator;

import org.apache.regexp.RE;

/**
 * ڸ Էߴ θ ǴѴ.
 * @author ֹ
 * @since 2.0.5.6
 */
public class NumberValidator implements Validator {
	
	/**
	 * parameterValues null̰ų, ̰ 0̰ų
	 * parameterValues[0]  ""  true Ѵ.
	 * 
	 * ׿  ([0-9]+)|([0-9]*\\.[0-9]+) ǥĿ شϴ
	 * θ Ǿ ִ  true,
	 * ׷   false Ѵ.
	 */
	public boolean test(String[] parameterValues, String constraint) {
		if (parameterValues == null ||
				parameterValues.length == 0 ||
				parameterValues[0].equals(""))
			return true;
		
		RE re = new RE("([0-9]+)|([0-9]*\\.[0-9]+)");
		if (re.match(parameterValues[0])) {
			return parameterValues[0].length() == re.getParenLength(0);
		}
		return false;
	}
}
