/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultUICreator.java
 * ۼ: 2004. 10. 28
 */
package tle.framework.component.impl.uicreator;

import java.io.File;
import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.uicreator.client.ClientType;
import tle.framework.component.impl.uicreator.config.CommandConfig;
import tle.framework.component.impl.uicreator.config.UIConfiguration;
import tle.framework.component.impl.uicreator.config.UIConfigurationDigester;
import tle.framework.component.impl.uicreator.config.ViewConfig;
import tle.framework.component.impl.uicreator.config.ViewSetConfig;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.Result;
import tle.framework.component.spi.uicreator.UICreator;
import tle.framework.log.Logger;
import tle.framework.util.TLEConfigPathUtil;

/**
 * UICreator ⺻  Ʈ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultUICreator extends ComponentBase implements UICreator,
		DefaultUICreatorMBean {
	public static final String VIEW_CONFIG_ATTRIBUTE_NAME = "DefaultUICreator.ViewConfig";
	
	private UIConfiguration uiConfig;
	/**
	 *   θ 
	 */
	private String configFile;
	
	/**
	 *  Ϸκ  о UIConfiguration ü Ѵ.
	 * <p>
	 *   δ Ʈ ʱȭ Ķ "configFile" Ѵ.
	 * <p>
	 * configFile ʱȭ Ķ͸  ʾ  Ȩ丮 "DefaultUICreator.xml"  Ѵ.
	 *   
	 * @see tle.framework.component.impl.ComponentBase#initing(tle.framework.component.ComponentConfig)
	 */
	protected void initing(ComponentConfig config) throws ComponentException {
		String configFilePath = config.getInitParameter("configFile");

		if (configFilePath == null) {
			configFilePath = System.getProperty("user.home") + File.separator + "DefaultUICreator.xml";
		}
		this.configFile = configFilePath;
		
		try {
			this.initConfiguration();
		} catch (Throwable e) {
			Logger.fatal("DefaultUICreator.initing():Configuration File Loading Error", e);
			throw new ComponentException(e.getMessage(), e);
		}
	}
	
	/**
	 * result  ڵ忡  ˸  ̵Ѵ.
	 * result νϽ request "result" Ӽ ȴ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createView(tle.framework.component.spi.rp.Result, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createView(Result result, HttpServletRequest request,
			HttpServletResponse response) throws ComponentException {
		
		String resultViewID = null;
		
		// globalViewID   óѴ.
		if (uiConfig.checkGlobalResultPrefix(result.getCode()) ) {
			// Result  ڵ尡  global Prefix  ϴ 
			String restCode = //  ڵ global prefix   κ
				result.getCode()
			          .substring(uiConfig.getGlobalResultPrefix().length());  
			resultViewID = uiConfig.getGlobalResultMapping(restCode);
		}
		
		if (resultViewID == null) { // , global view  result ƴ 
			CommandConfig commandConfig = uiConfig.getCommandConfig(result.getCommandID());
			if (commandConfig == null)
				throw new ComponentException("Not Matching UI CommandConfig for command:"+result.getCommandID());
			
			resultViewID = commandConfig.getResultViewID(result.getCode());
		}
		if (resultViewID == null) {
			throw new ComponentException("Not Matching View for (command, result): ("+result.getCommandID()+","+result.getCode()+")");
		}
		
		ViewSetConfig viewSet = null;
		int viewSetDilimeter = resultViewID.indexOf(":");
		String realResultViewID = null;
		if (viewSetDilimeter > 0 && viewSetDilimeter != resultViewID.length() - 1) {
			String viewSetID = resultViewID.substring(0, viewSetDilimeter);
			viewSet = uiConfig.getViewSetConfig(viewSetID);
			realResultViewID = resultViewID.substring(viewSetDilimeter+1);
		} else {
			realResultViewID = resultViewID;
		}
		if (viewSet == null) viewSet = getViewSetConfig(request);
		
		ViewConfig viewConfig = viewSet.getViewConfig(realResultViewID);
		if (viewConfig == null) {
			throw new ComponentException("Not Matching UI ViewConfig for [COMMAND ID,RESULT CODE, VIEW_SET, VIEW_ID]:["+result.getCommandID()+","+result.getCode()+","+viewSet.getViewSetID()+","+resultViewID+"]");
		}
		request.setAttribute("result", result);
		
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 * ȭ ̵Ѵ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createAuthenticationForm(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createAuthenticationForm(HttpServletRequest request,
			HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getAuthFormViewConfig();
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 * Ѿٴ ޽ ִ ȭ ̵Ѵ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createNoAuthorizationView(tle.framework.component.spi.ra.RequestInfo, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createNoAuthorizationView(RequestInfo ri,
			HttpServletRequest request, HttpServletResponse response)
			throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getNoAuthViewConfig();
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 *   ȭ ̵Ѵ.
	 * <p>
	 * result νϽ request "result" Ӽ ȴ.
	 * <p>
	 * result.getException() ϴ  ü request
	 * javax.servlet.error.exception Ӽ javax.servlet.jsp.jspException Ӽ
	 * Ѵ.
	 * 
	 * @see tle.framework.component.spi.uicreator.UICreator#createErrorView(tle.framework.component.spi.rp.Result, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createErrorView(Result result, HttpServletRequest request,
			HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getErrorViewConfig();
		
		request.setAttribute("result", result);
		if (result.isErrorOccured() && result.getException() != null) {
			request.setAttribute("javax.servlet.error.exception", result.getException());
			request.setAttribute("javax.servlet.jsp.jspException", result.getException());
		}
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 *   ȭ ̵Ѵ.
	 * <p>
	 * ڷ ޹ Throwable ü request
	 * javax.servlet.error.exception Ӽ javax.servlet.jsp.jspException Ӽ
	 * Ѵ.
	 * @see tle.framework.component.spi.uicreator.UICreator#createErrorView(java.lang.Throwable, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void createErrorView(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws ComponentException {
		ViewSetConfig viewSet = getViewSetConfig(request);
		ViewConfig viewConfig = viewSet.getErrorViewConfig();
		
		request.setAttribute("javax.servlet.error.exception", exception);
		request.setAttribute("javax.servlet.jsp.jspException", exception);
		
		try {
			this.forward(viewConfig, request, response);
		} catch (ServletException e) {
			throw new ComponentException(e.getMessage(), e);
		} catch (IOException e) {
			throw new ComponentException(e.getMessage(), e);
		}
	}

	/**
	 * User-Agent  ViewSetConfig Ѵ.
	 * 
	 * @param request HTTP û
	 */
	private ViewSetConfig getViewSetConfig(HttpServletRequest request) {
		String clientType = ClientType.getClientType(request);
		return uiConfig.getClientViewSetConfig(clientType);
	}
	
	/**
	 * viewConfig Ÿ  ̵Ѵ.
	 * <p>
	 * ViewConfig ü request DefaultUICreator.ViewConfig Ӽ Ѵ.
	 * <p>
	 * viewConfig.getRelatedPage() ޼ҵ ϰ ̵  URI Ѵ.
	 * 
	 * @param viewConfig   
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ServletException
	 * @throws IOException
	 * @throws ComponentException
	 */
	private void forward(ViewConfig viewConfig, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, ComponentException {
		try {
			if (viewConfig == null) throw new ComponentException("ViewConfig cannot be null");
			
			if (viewConfig.isRedirect()) {
				// {context.path} ϸ  ؽƮ  ΰ ȴ.
				if (viewConfig.getPage() != null) {
					int idx = viewConfig.getPage().indexOf("{context.path}");
					if (idx == 0) {
						response.sendRedirect(request.getContextPath()+viewConfig.getPage().substring(14));
					} else {
						response.sendRedirect(viewConfig.getPage());
					}
				} else {
					throw new ComponentException("Redirect view's page cannot be null:"+viewConfig.getViewID());
				}
			} else {
				request.setAttribute(VIEW_CONFIG_ATTRIBUTE_NAME, viewConfig);
				RequestDispatcher dispatcher = request.getRequestDispatcher(viewConfig.getRelatedPage());
				dispatcher.forward(request, response);
			}
		} catch(ServletException e) {
			Logger.fatal("DefaultUICreator.forward():"+e.getMessage(), e);
			throw e;
		} catch(IOException e) {
			Logger.fatal("DefaultUICreator.forward():"+e.getMessage(), e);
			throw e;
		}
	}
	
	/**
	 * @see tle.framework.component.impl.uicreator.DefaultUICreatorMBean#getConfigFile()
	 */
	public String getConfigFile() {
		return configFile;
	}
	/**
	 *  Ϸκ   о uiConfig ʵ忡 ҴѴ.
	 * 
	 * @throws Throwable
	 */
	private void initConfiguration() throws Throwable {
		uiConfig = UIConfigurationDigester.create(TLEConfigPathUtil.replace(configFile));
	}
	
	/**
	 *  Ϸκ   ٽ о´.
	 * @see tle.framework.component.impl.uicreator.DefaultUICreatorMBean#reloadConfiguration()
	 */
	public void reloadConfiguration() throws ComponentException {
		try {
			initConfiguration();
		} catch (Throwable e) {
			Logger.fatal("DefaultUICreator.reloadConfiguration():Configuration File Loading Error", e);
			throw new ComponentException(e.getMessage(), e);
		}
	}

}
