/*
 * Ʈ: TLE2Framework
 * ϸ: UIConfigurationDigester.java
 * ۼ: 2004. 10. 29
 */
package tle.framework.component.impl.uicreator.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

/**
 *  Ϸκ UIConfiguration ü Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class UIConfigurationDigester {
	private static Digester digester = null;
	
	public static UIConfiguration create(String filePath) throws IOException, SAXException {
		if (digester == null) {
			UIConfigurationDigester.initDigester();
		}
		File configFile = new File(filePath);
		UIConfiguration configuration = (UIConfiguration)digester.parse(configFile);
		return configuration;
	}
	
	private static void initDigester() {
		synchronized(UIConfigurationDigester.class) {
			if (digester == null) {
				URL ruleXml = UIConfigurationDigester.class.getClassLoader().getResource("tle/framework/component/impl/uicreator/config/UIConfiguration.rule.xml");
				digester = DigesterLoader.createDigester(ruleXml);
			}
		}
	}
}
