#
# $Id: Rules.make,v 1.2 2002/09/09 05:44:23 halite Exp $
#

# object target
$(O_TARGET): $(O_TARGET_OBJS)
	$(LD) -r -o $@ $(O_TARGET_OBJS)

# library target
$(L_TARGET): $(L_TARGET_OBJS)
	rm -f $@
	$(AR) rcs $@ $(L_TARGET_OBJS)

# normal compile method
%.o: %.c
	$(CC) -c $(CFLAGS) -o $@ $<

%.s: %.S
	$(CPP) -c $(AFLAGS) $< > $@

%.o: %.s
	$(AS) -c -$(AFLAGS) -o $@ $<

%.o: %.S
	$(CC) $(AFLAGS) -c -o $@ $<

#
# This make dependencies quickly
#
fastdep: dummy
	$(TOPDIR)/scripts/mkdep $(CFLAGS) $(EXTRA_CFLAGS_nostdinc) -- $(wildcard *.[chS]) > .depend
ifdef ALL_SUB_DIRS
	$(MAKE) $(patsubst %,_sfdep_%,$(ALL_SUB_DIRS)) _FASTDEP_ALL_SUB_DIRS="$(ALL_SUB_DIRS)"
endif

ifdef _FASTDEP_ALL_SUB_DIRS
$(patsubst %,_sfdep_%,$(_FASTDEP_ALL_SUB_DIRS)):
	$(MAKE) -C $(patsubst _sfdep_%,%,$@) fastdep
endif

# A rule to make subdirectories
subdir-list = $(sort $(patsubst %,_subdir_%,$(SUB_DIRS)))
sub_dirs: dummy $(subdir-list)

ifdef SUB_DIRS
$(subdir-list) : dummy
	$(MAKE) -C $(patsubst _subdir_%,%,$@)
endif

.PHONY: dummy

dummy:

# include dependancy file
ifeq (.depend, $(wildcard .depend))
include .depend
endif

ifeq (.hdepend, $(wildcard .hdepend))
include .hdepend
endif
