/*
 * $Id: printk.c,v 1.1.1.1 2002/08/28 02:53:20 halite Exp $
 *
 * Create by halite on 2002.08.28
 *
 */

#include <toykernel/stdarg.h>
#include <toykernel/stddef.h>
#include <toykernel/kernel.h>

#define COLUMNS                 80
#define LINES                   24
#define ATTRIBUTE               7
#define VIDEO                   0xB8000

static int xpos = 0;
static int ypos = 0;
static volatile unsigned char *video;

void test_cls(void)
{
	int i;

	video = (unsigned char *) VIDEO;
  
	for (i = 0; i < COLUMNS * LINES * 2; i++)
		*(video + i) = 0;

	xpos = 0;
	ypos = 0;
}

void test_putchar(int c)
{
	if (c == '\n' || c == '\r')
	{
	newline:
		xpos = 0;
		ypos++;
		if (ypos >= LINES)
			ypos = 0;
		return;
	}

	*(video + (xpos + ypos * COLUMNS) * 2) = c & 0xFF;
	*(video + (xpos + ypos * COLUMNS) * 2 + 1) = ATTRIBUTE;

	xpos++;
	if (xpos >= COLUMNS)
		goto newline;
}

void test_write(const char *p, int cnt)
{
	int i;

	for (i = 0; i < cnt; i++)
		test_putchar((int)p[i]);
}

int printk(const char *fmt, ...)
{
	static char printk_buf[1024];
	va_list args;
	int cnt;

	va_start(args, fmt);
	cnt = vsprintf(printk_buf, fmt, args);
	va_end(args);
	/*
	__asm__("push %%fs\n\t"
		"push %%ds\n\t"
		"pop %%fs\n\t"
		"pushl %0\n\t"
		"pushl $_buf\n\t"
		"pushl $0\n\t"
		"call _tty_write\n\t"
		"addl $8,%%esp\n\t"
		"popl %0\n\t"
		"pop %%fs"
		::"r" (i):"ax","cx","dx");
	*/
	test_write(printk_buf, cnt);
	return cnt;
}
