; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "ZViewer"
!define PRODUCT_VERSION "0.7.0"
!define PRODUCT_PUBLISHER "RhLab"
!define PRODUCT_WEB_SITE "http://zviewer.wimy.com"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor /SOLID lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
;!define MUI_LICENSEPAGE_CHECKBOX
!insertmacro MUI_PAGE_LICENSE "ReadMe.txt"
; Directory page
!define MUI_PAGE_CUSTOMFUNCTION_SHOW onDirectoryShow
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; start of languages ----------
;!insertmacro MUI_LANGUAGE "English"

;!insertmacro MUI_LANGUAGE "Korean"

; end of languages ----------

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!include ".\language\english.nsh"

!insertmacro MUI_LANGUAGE "Korean"
!include ".\language\korean.nsh"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}Setup${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
InstallDirRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ZViewer" "UninstallString"
ShowInstDetails show
ShowUnInstDetails show
CRCCheck on

Function .onInit
; installer       ´.
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

; 丮  ȭ   Ǵ Լ. ̹ ġ  丮     Ѵ.
Function onDirectoryShow
  push $R0
  push $R1
  ReadRegStr $0 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ZViewer" "UninstallString"
  IfErrors onDirectoryShowEnd onDirectoryShowDisableBrowse
onDirectoryShowDisableBrowse:
  FindWindow $R0 "#32770" "" $HWNDPARENT
  GetDlgItem $R1 $R0 1019
  EnableWindow $R1 0
  GetDlgItem $R1 $R0 1001
  EnableWindow $R1 0
; ' ġ 丮 '  ޽ 'ٽ ġմϴ'   ٲ
  GetDlgItem $R1 $R0 1006
  SendMessage $R1 ${WM_SETTEXT} 0 "STR:$(TEXT_REINSTALL)"

onDirectoryShowEnd:
  pop $R1
  pop $R0
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite on

; Preview Extension DLLs
  IfFileExists "$INSTDIR\ZViewerAgent.dll" ZViewerDllCheck ZViewerCopyDll

ZViewerDllCheck:
  Delete "$INSTDIR\ZViewerAgent.dll"
  IfErrors ZViewerNeedKillExplorer ZViewerCopyDll

ZViewerNeedKillExplorer:
  MessageBox MB_OK $(RestartExplorer)
  KillProcDLL::KillProc "explorer.exe"

; explorer  ٷ ׾ dll  ϴ ӵ    Ƿ  
  Sleep 1000

ZViewerCopyDll:

  File "dbghelp.dll"
  File "ZViewerIcons.dll"
  File "ZViewer.exe"
  File "_ZViewer.png"
  File "LoadError.png"
  File "License.txt"
  File "ReadMe.txt"

  File "FreeImage.dll"
  File "FreeImagePlus.dll"
  File "ZViewerAgent.dll"

; Language Files 
  SetOutPath "$INSTDIR\language"
  File "language\korean.dll"
  File "language\korean.txt"
  File "language\english.txt"

; Register DLL
  SetOutPath "$INSTDIR" ; RegDll  ϱ ؼ   Ѵ.
  RegDll "$INSTDIR\ZViewerAgent.dll"
  ExecWait "$INSTDIR\ZViewer.exe /fileext"

; explorer.exe     ش.
  FindProcDLL::FindProc "explorer.exe"
  StrCmp $R0 1 ZViewerEnd ZViewerExecExplorer

ZViewerExecExplorer:
  Exec "explorer.exe"
ZViewerEnd:

SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ZViewer Homepage.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk" "$INSTDIR\uninst.exe"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ZViewer.lnk" "$INSTDIR\ZViewer.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK $(UninstallCompleted)
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 $(UninstallQuestion) IDYES +2
  Abort
FunctionEnd

Section Uninstall
  UnRegDll "$INSTDIR\ZViewerAgent.dll"

  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\ZViewer.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\ZViewerAgent.lnk"

  RMDir "$SMPROGRAMS\${PRODUCT_NAME}"
  RMDir /rebootok /r "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
